//
// table_O_S_2f_2.h
// GSFontTools
//
// Created by Georg Seifert on 09.11.12
// Copyright 2012 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GSFontTools/OTTables.h>

// panose classification
//
typedef struct {
	uint8_t panoseFamilyType;	   // B
	uint8_t panoseSerifStyle;	   // B
	uint8_t panoseWeight;		   // B
	uint8_t panoseProportion;	   // B
	uint8_t panoseContrast;		   // B
	uint8_t panoseStrokeVariation; // B
	uint8_t panoseArmStyle;		   // B
	uint8_t panoseLetterForm;	   // B
	uint8_t panoseMidline;		   // B
	uint8_t panoseXHeight;		   // B
} panoseFormat;

typedef NS_ENUM(uint16_t, GSOS2FsSelection) {
	GSOS2FsSelectionItalic = 1,				 // Font contains italic or oblique glyphs, otherwise they are upright.
	GSOS2FsSelectionUnderscore = 1 << 1,	 // glyphs are underscored.
	GSOS2FsSelectionNegative = 1 << 2,		 // glyphs have their foreground and background reversed.
	GSOS2FsSelectionOutlined = 1 << 3,		 // Outline (hollow) glyphs, otherwise they are solid.
	GSOS2FsSelectionStrikeout = 1 << 4,		 // glyphs are overstruck.
	GSOS2FsSelectionBold = 1 << 5,			 // glyphs are emboldened.
	GSOS2FsSelectionRegular = 1 << 6,		 // glyphs are in the standard weight/style for the font.
	GSOS2FsSelectionUseTypoMetrics = 1 << 7, // If set, it is strongly recommended that applications use OS/2.sTypoAscender - OS/2.sTypoDescender + OS/2.sTypoLineGap as the default line spacing for this font.
	GSOS2FsSelectionHasWWSNames = 1 << 8,	 // the font has 'name' table strings consistent with a weight/width/slope family without requiring use of name IDs 21 and 22. (Please see more detailed description below.)
	GSOS2FsSelectionOblique = 1 << 9,		 //
};

@interface table_O_S_2f_2 : BaseTTXConverter {
	uint16_t _version;
  @public
	int16_t _xAvgCharWidth;			// h  average character width
	uint16_t _usWeightClass;		// H  degree of thickness of strokes
	uint16_t _usWidthClass;			// H  aspect ratio
	uint16_t _fsType;				// h  type flags
	int16_t _ySubscriptXSize;		// h  subscript horizontal font size
	int16_t _ySubscriptYSize;		// h  subscript vertical font size
	int16_t _ySubscriptXOffset;		// h  subscript x offset
	int16_t _ySubscriptYOffset;		// h  subscript y offset
	int16_t _ySuperscriptXSize;		// h  superscript horizontal font size
	int16_t _ySuperscriptYSize;		// h  superscript vertical font size
	int16_t _ySuperscriptXOffset;	// h  superscript x offset
	int16_t _ySuperscriptYOffset;	// h  superscript y offset
	int16_t _yStrikeoutSize;		// h  strikeout size
	int16_t _yStrikeoutPosition;	// h  strikeout position
	int16_t _sFamilyClass;			// h  font family class and subclass
	uint8_t _panose[10];
	// uint32_t _ulUnicodeRange1;	// L character range
	// uint32_t _ulUnicodeRange2;	// L character range
	// uint32_t _ulUnicodeRange3;	// L character range
	// uint32_t _ulUnicodeRange4;	// L character range

	char _achVendID[4];				// 4s font vendor identification
	GSOS2FsSelection _fsSelection;	// H  font selection flags
	uint16_t _usFirstCharIndex;		// H  first unicode character index
	uint16_t _usLastCharIndex;		// H  last unicode character index
	int16_t _sTypoAscender;			// h  typographic ascender
	int16_t _sTypoDescender;		// h  typographic descender
	int16_t _sTypoLineGap;			// h  typographic line gap
	uint16_t _usWinAscent;			// H  Windows ascender
	uint16_t _usWinDescent;			// H  Windows descender
	// /format 0

	// uint32_t _ulCodePageRange1;	// L
	// uint32_t _ulCodePageRange2;	// L
	// /format 1

	int16_t _sxHeight;				// h
	int16_t _sCapHeight;			// h
	int16_t _usDefaultChar;			// H
	int16_t _usBreakChar;			// H
	int16_t _usMaxContext;			// H
	// /format 2

	int16_t _usLowerOpticalPointSize;
	int16_t _usUpperOpticalPointSize;
	// format 5
}
@property (nonatomic, assign) uint16_t version;

@property (nonatomic, assign) int16_t xAvgCharWidth;
@property (nonatomic, assign) uint16_t usWeightClass;
@property (nonatomic, assign) uint16_t usWidthClass;
@property (nonatomic, assign) uint16_t fsType;
@property (nonatomic, assign) int16_t ySubscriptXSize;
@property (nonatomic, assign) int16_t ySubscriptYSize;
@property (nonatomic, assign) int16_t ySubscriptXOffset;
@property (nonatomic, assign) int16_t ySubscriptYOffset;
@property (nonatomic, assign) int16_t ySuperscriptXSize;
@property (nonatomic, assign) int16_t ySuperscriptYSize;
@property (nonatomic, assign) int16_t ySuperscriptXOffset;
@property (nonatomic, assign) int16_t ySuperscriptYOffset;
@property (nonatomic, assign) int16_t yStrikeoutSize;
@property (nonatomic, assign) int16_t yStrikeoutPosition;
@property (nonatomic, assign) int16_t sFamilyClass;
@property (nonatomic, assign) NSArray *panose;
@property (nonatomic, strong) NSIndexSet *unicodeRanges;
@property (nonatomic, assign) NSString *achVendID;
@property (nonatomic, assign) GSOS2FsSelection fsSelection;
@property (nonatomic, assign) uint16_t usFirstCharIndex;
@property (nonatomic, assign) uint16_t usLastCharIndex;
@property (nonatomic, assign) int16_t sTypoAscender;
@property (nonatomic, assign) int16_t sTypoDescender;
@property (nonatomic, assign) int16_t sTypoLineGap;
@property (nonatomic, assign) uint16_t usWinAscent;
@property (nonatomic, assign) uint16_t usWinDescent;
	// /format 0
@property (nonatomic, strong) NSIndexSet *codePageRanges;
	// /format 1

@property (nonatomic, assign) int16_t sxHeight;
@property (nonatomic, assign) int16_t sCapHeight;
@property (nonatomic, assign) int16_t usDefaultChar;
@property (nonatomic, assign) int16_t usBreakChar;
@property (nonatomic, assign) int16_t usMaxContext;
	// /format 2

@property (nonatomic, assign) int16_t usLowerOpticalPointSize;
@property (nonatomic, assign) int16_t usUpperOpticalPointSize;



- (void)recalcUnicodeRanges:(TTFont *)ttFont;
- (void)recalcCodePageRanges:(TTFont *)ttFont;

@end
